# Generated by Django 3.1.4 on 2020-12-30 08:53

from django.db import migrations
from django.core.exceptions import ObjectDoesNotExist


def add_aa_team_token(apps, schema_editor):
    # We can't import the Person model directly as it may be a newer
    # version than this migration expects. We use the historical version.
    Tokens = apps.get_model('analytics', 'AnalyticsTokens')
    AnalyticsPath = apps.get_model('analytics', 'AnalyticsPath')
    token = Tokens()
    try:
        ua_token = Tokens.objects.get(token="UA-186249766-2")
        original_send_page_views = ua_token.send_page_views
        original_send_celery_tasks = ua_token.send_celery_tasks
        original_send_stats = ua_token.send_stats
    except ObjectDoesNotExist:
        original_send_page_views = True
        original_send_celery_tasks = True
        original_send_stats = True

    try:
        user_notifications_count = AnalyticsPath.objects.get(ignore_path=r"^\/user_notifications_count\/.*",)
    except ObjectDoesNotExist:
        user_notifications_count = AnalyticsPath.objects.create(ignore_path=r"^\/user_notifications_count\/.*")

    try:
        admin = AnalyticsPath.objects.get(ignore_path=r"^\/admin\/.*")
    except ObjectDoesNotExist:
        admin = AnalyticsPath.objects.create(ignore_path=r"^\/admin\/.*")

    try:
        account_activate = AnalyticsPath.objects.get(ignore_path=r"^\/account\/activate\/.*")
    except ObjectDoesNotExist:
        account_activate = AnalyticsPath.objects.create(ignore_path=r"^\/account\/activate\/.*")

    token.type = 'GA-V4'
    token.token = 'G-6LYSMYK8DE'
    token.secret = 'KLlpjLZ-SRGozS5f5wb_kw'
    token.send_page_views = original_send_page_views
    token.send_celery_tasks = original_send_celery_tasks
    token.send_stats = original_send_stats
    token.name = 'AA Team Public Google Analytics (V4)'
    token.save()
    token.ignore_paths.add(admin, user_notifications_count, account_activate)
    token.save()


def remove_aa_team_token(apps, schema_editor):
    # Have to define some code to remove this identifier
    # In case of migration rollback?
    Tokens = apps.get_model('analytics', 'AnalyticsTokens')
    token = Tokens.objects.filter(token="G-6LYSMYK8DE").delete()


class Migration(migrations.Migration):

    dependencies = [
        ('analytics', '0007_analyticstokens_secret'),
    ]

    operations = [migrations.RunPython(
        add_aa_team_token, remove_aa_team_token)]
